DROP TABLE IF EXISTS `#@_admin`;
CREATE TABLE `#@_admin` (
  `uid` int(10) unsigned NOT NULL auto_increment COMMENT 'UID',
  `name` varchar(30) NOT NULL COMMENT '用户名',
  `password` char(32) NOT NULL COMMENT '密码',
  `email` varchar(50) NOT NULL COMMENT '管理组',
  `pre` smallint(5) NOT NULL default '0',
  PRIMARY KEY  (`uid`),
  UNIQUE KEY `uname` (`name`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#@_adsense`;
CREATE TABLE `#@_adsense` (
  `id` smallint(5) unsigned NOT NULL auto_increment,
  `title` varchar(50) NOT NULL,
  `des` varchar(50) NOT NULL default '' COMMENT '说明',
  `content` text NOT NULL,
  `status` tinyint(1) NOT NULL default '1',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#@_article`;
CREATE TABLE `#@_article` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `cid` smallint(5) NOT NULL,
  `title` varchar(250) NOT NULL,
  `tag` varchar(100) NOT NULL default '' COMMENT '标签',
  `color` char(8) NOT NULL default '',
  `cover` varchar(250) NOT NULL default '' COMMENT '封面',
  `author` varchar(50) NOT NULL default '' COMMENT '作者',
  `comeurl` varchar(250) NOT NULL default '' COMMENT '来源',
  `remark` text NOT NULL,
  `short_title` text,
  `keywords` text,
  `content` longtext NOT NULL,
  `hits` mediumint(8) NOT NULL default '0',
  `star` tinyint(1) NOT NULL default '1',
  `status` tinyint(1) NOT NULL default '1',
  `up` mediumint(8) NOT NULL default '0',
  `down` mediumint(8) NOT NULL default '0',
  `addtime` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `cid` (`cid`),
  KEY `hits` (`hits`),
  KEY `star` (`star`),
  KEY `status` (`status`),
  KEY `up` (`up`),
  KEY `down` (`down`),
  KEY `addtime` (`addtime`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#@_attach`;
CREATE TABLE `#@_attach` (
  `id` int(10) unsigned NOT NULL auto_increment COMMENT '附件ID',
  `article_id` int(10) unsigned NOT NULL default '0' COMMENT '主题ID',
  `uid` int(10) unsigned NOT NULL default '0' COMMENT '用户ID',
  `name` varchar(100) NOT NULL default '' COMMENT '文件名',
  `remark` text NOT NULL COMMENT '文件描述',
  `size` int(11) NOT NULL default '0' COMMENT '文件大小',
  `file` varchar(250) NOT NULL COMMENT '文件路径',
  `ext` varchar(10) NOT NULL COMMENT '文件类型',
  `status` tinyint(1) NOT NULL default '1' COMMENT '状态, 1:正常 0:隐藏',
  `type` tinyint(1) NOT NULL default '0' COMMENT '附件类型, 0:本地文件, 1:网络文件',
  `try_count` tinyint(2) NOT NULL default '0' COMMENT '重试次数',
  `upload_time` int(10) unsigned NOT NULL default '0' COMMENT '上传时间',
  PRIMARY KEY  (`id`),
  KEY `article_id` (`article_id`),
  KEY `type` (`type`,`try_count`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#@_cache`;
CREATE TABLE `#@_cache` (
  `name` varchar(40) NOT NULL default '' COMMENT '字符串',
  `value` text NOT NULL COMMENT '显示文字',
  `package` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP COMMENT '时间',
  PRIMARY KEY  (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='公用数据存贮';

DROP TABLE IF EXISTS `#@_cate`;
CREATE TABLE `#@_cate` (
  `cid` smallint(5) unsigned NOT NULL auto_increment,
  `pid` smallint(5) NOT NULL,
  `oid` smallint(5) NOT NULL default '0',
  `view_type` tinyint(1) NOT NULL default '0' COMMENT '内容显示模式:0: 普通模式, 1:幻灯模式',
  `status` tinyint(1) NOT NULL default '1',
  `index` tinyint(1) NOT NULL default '0',
  `name` varchar(30) NOT NULL default '',
  `eng_name` varchar(30) NOT NULL default '',
  `ctpl` varchar(30) NOT NULL default '' COMMENT '分类模板',
  `ctitle` varchar(50) NOT NULL,
  `ckeywords` varchar(255) NOT NULL,
  `cdescription` varchar(255) NOT NULL,
  PRIMARY KEY  (`cid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#@_config`;
CREATE TABLE `#@_config` (
  `name` varchar(40) NOT NULL default '' COMMENT '字符串',
  `value` text NOT NULL COMMENT '显示文字',
  `des` varchar(50) NOT NULL default '' COMMENT '说明',
  PRIMARY KEY  (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='语言包(简体中文)';

DROP TABLE IF EXISTS `#@_lang_chs`;
CREATE TABLE `#@_lang_chs` (
  `name` varchar(40) NOT NULL default '' COMMENT '字符串',
  `value` text NOT NULL COMMENT '显示文字',
  PRIMARY KEY  (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='语言包(简体中文)';

DROP TABLE IF EXISTS `#@_link`;
CREATE TABLE `#@_link` (
  `id` smallint(5) unsigned NOT NULL auto_increment,
  `title` varchar(50) NOT NULL,
  `logo` varchar(255) NOT NULL,
  `url` varchar(255) NOT NULL,
  `oid` tinyint(3) NOT NULL,
  `type` tinyint(1) NOT NULL,
  `status` tinyint(1) NOT NULL default '1',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#@_system`;
CREATE TABLE `#@_system` (
  `id` smallint(5) unsigned NOT NULL auto_increment,
  `oid` smallint(5) NOT NULL default '0',
  `status` tinyint(1) NOT NULL default '1',
  `name` varchar(30) NOT NULL default '',
  `eng_name` varchar(30) NOT NULL default '',
  `stitle` varchar(50) NOT NULL,
  `skeywords` varchar(255) NOT NULL,
  `sdescription` varchar(255) NOT NULL,
  `content` longtext NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#@_tags`;
CREATE TABLE `#@_tags` (
  `tag` varchar(30) NOT NULL,
  `title` varchar(250) NOT NULL COMMENT '文章标题',
  `article_id` int(11) NOT NULL COMMENT '文章ID',
  KEY `tag` (`tag`),
  KEY `article_id` (`article_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#@_topic`;
CREATE TABLE `#@_topic` (
  `tid` smallint(5) unsigned NOT NULL auto_increment,
  `oid` smallint(5) NOT NULL default '0',
  `status` tinyint(1) NOT NULL default '1',
  `name` varchar(30) NOT NULL default '',
  `eng_name` varchar(30) NOT NULL default '',
  `stpl` varchar(30) NOT NULL,
  `stitle` varchar(50) NOT NULL,
  `skeywords` varchar(255) NOT NULL,
  `sdescription` varchar(255) NOT NULL,
  `cover` varchar(250) NOT NULL,
  `content` longtext NOT NULL,
  PRIMARY KEY  (`tid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `#@_admin` (`uid`, `name`, `password`, `email`, `pre`) VALUES
(1, 'admin', '00df138c4277ebb79f76178c4e96cc54', '', 15);

INSERT INTO `#@_adsense` (`id`, `title`, `des`, `content`, `status`) VALUES
('1', 'ad_1', '980-90', '<a href=\"http://www.tutucms.com\" target=\"_blank\"><img border=\"0\" src=\"{$web_url}images/ad/980-90.jpg\" width=\"980\" height=\"90\"></a>', '1'),
('2', 'ad_2', '300-250', '<a href=\"http://www.tutucms.com\" target=\"_blank\"><img border=\"0\" src=\"{$web_url}images/ad/300-250.jpg\" width=\"300\" height=\"250\"></a>', '1'),
('3', 'ad_3', '300-250', '<a href=\"http://www.tutucms.com\" target=\"_blank\"><img border=\"0\" src=\"{$web_url}images/ad/300-250.jpg\" width=\"300\" height=\"250\"></a>', '1'),
('4', 'ad_4', '980-90', '<a href=\"http://www.tutucms.com\" target=\"_blank\"><img border=\"0\" src=\"{$web_url}images/ad/980-90.jpg\" width=\"980\" height=\"90\"></a>', '1'),
('5', 'ad_5', '960-60', '<a href=\"http://www.tutucms.com\" target=\"_blank\"><img border=\"0\" src=\"{$web_url}images/ad/960-60.jpg\" width=\"960\" height=\"60\"></a>', '1'),
('6', 'ad_6', '960-60', '<a href=\"http://www.tutucms.com\" target=\"_blank\"><img border=\"0\" src=\"{$web_url}images/ad/960-60.jpg\" width=\"960\" height=\"60\"></a>', '1'),
('7', 'ad_7', '956-30', '<a href=\"http://www.tutucms.com\" target=\"_blank\"><img border=\"0\" src=\"{$web_url}images/ad/960-30.jpg\" width=\"956\"></a>', '1'),
('8', 'ad_8', '956-30', '<a href=\"http://www.tutucms.com\" target=\"_blank\"><img border=\"0\" src=\"{$web_url}images/ad/960-30.jpg\" width=\"956\"></a>', '1'),
('9', 'ad_9', '300-300', '<a href=\"http://www.tutucms.com\" target=\"_blank\"><img border=\"0\" src=\"{$web_url}images/ad/300-300.jpg\" width=\"300\" height=\"300\"></a>', '1');

INSERT INTO `#@_config` (`name`, `value`, `des`) VALUES
('web_name', 'TUTUCMS图片网站管理系统', ''),
('admin_name', 'TUTUCMS', ''),
('web_url', 'http://localhost/tutucms/', ''),
('web_path', '/tutucms/', ''),
('web_email', 'admin@tutucms.com', ''),
('web_icp', '未备案', ''),
('web_hotkey', 'TUTUCMS,图片网站管理系统', ''),
('web_keywords', 'TUTUCMS,图片网站管理系统', ''),
('web_description', 'TUTUCMS图片网站管理系统', ''),
('web_copyright', 'Copyright © 2015 <strong>WWW.TUTUCMS.COM</strong>, All Rights Reserved TUTUCMS 版权所有', ''),
('admin_vcode', '0', ''),
('web_tongji', '', ''),
('upload_http_thumb', '0', ''),
('template_skin', 'default', ''),
('web_admin_pagenum', '20', ''),
('web_list_pagenum', '27', ''),
('web_list_pagesnum', '2', ''),
('web_list_tagsnum', '600', ''),
('web_maps_num', '100', ''),
('web_rss_num', '100', ''),
('web_pick_hits', '1000', ''),
('web_pick_up', '1000', ''),
('web_adsensepath', '', ''),
('upload_path', 'attach', ''),
('upload_style', 'Y-m-d', ''),
('upload_thumb_type', '1', ''),
('upload_thumb_w', '100', ''),
('upload_thumb_h', '100', ''),
('upload_cut_pct', '90', ''),
('upload_resize', '1', ''),
('upload_max_w', '960', ''),
('upload_max_h', '960', ''),
('upload_water', '1', ''),
('upload_water_img', 'images/water.png', ''),
('upload_water_pct', '80', ''),
('upload_fonts', 'arial.ttf', ''),
('upload_water_gif', '0', ''),
('upload_water_pos', '9', ''),
('upload_max_num', '30', ''),
('upload_dispatch', '0', ''),
('upload_safe_link', '0', ''),
('upload_safe_domain', 'tutucms.com', ''),
('upload_ftp', '0', ''),
('upload_ftp_host', '', ''),
('upload_ftp_user', '', ''),
('upload_ftp_pass', '', ''),
('upload_ftp_port', '', ''),
('upload_ftp_dir', '', ''),
('upload_ftp_url', '', ''),
('url_mode', '0', ''),
('url_suffix', '.html', ''),
('url_html_index', '0', ''),
('url_html_cate', '0', ''),
('url_html_content', '0', ''),
('url_html_maps', '0', ''),
('url_dir_cate', 'html', ''),
('url_dir_content', 'article', ''),
('url_dir_maps', 'html', ''),
('url_create_time', '1', ''),
('url_create_num', '10', ''),
('html_cache_on', '0', ''),
('html_cache_index', '60', ''),
('html_cache_cate', '60', ''),
('html_cache_content', '60', ''),
('web_article_pagenum', '1', ''),
('url_route_on', '0', ''),
('url_route_rule_cate', 'list', ''),
('url_route_rule_article', 'article', ''),
('url_route_rule_tags', 'tags', ''),
('url_route_rule_search', 'search', ''),
('url_route', '1', ''),
('upload_water_text', 'TUTUCMS.COM', ''),
('upload_water_textcolor', 'ffffff', ''),
('upload_water_bgcolor', '000000', ''),
('ad_switch', '0', ''),
('web_c_p', '1', ''),
('web_ds', '', ''),
('web_cy_appid', '', ''),
('web_cy_conf', '', ''),
('web_uy_uid', '', ''),
('url_html_system', '0', ''),
('url_route_rule_system', 'system', ''),
('url_html_topic', '0', ''),
('url_route_rule_topic', 'topic', '');

INSERT INTO `#@_lang_chs` (`name`, `value`) VALUES
('cms_name', 'TUTUCMS图片网站管理系统'),
('cms_ver', 'x2.0');

INSERT INTO `#@_link` (`id`, `title`, `logo`, `url`, `oid`, `type`) VALUES
(1, 'TUTUCMS官网', '', 'http://www.tutucms.com', 1, 1),
(2, '帅哥图片演示站', '', 'http://www.shuaiggs.com', 2, 1);